const Database = require("../../database/clsQueryProcess");
// const printReport = require('./clsPrintReport');
// const IOnlinePrint = require('../../../Interfaces/IOnlinePrint.model');
const globalData = require("../../global/globalData");
const database = new Database();
const clsBatchSummary = require("../Product/clsBatchSummaryOperation");
// const objPrintReport = new printReport();
// const serverConfig = require('../../global/severConfig')
let clsGetMstSrAndSideSr = require("../Product/clsGetMstSrAndSideSr");
// const objGetMstSrAndSideSr = new clsGetMstSrAndSideSr()
const date = require("date-and-time");
const momentObj = require("moment");

const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const { mode } = require("stats-lite");
// const ErrorLog = require('../clsErrorLog');
const objBatchSummary = new clsBatchSummary();
const objGetMstSrAndSideSr = new clsGetMstSrAndSideSr();
class WeighmentDataTransfer {
  /**
   *
   * @param {*} resultdata
   * @param {*} weighmentModeNo
   * @param {*} Idsno
   */
  async saveCommonDataToComplete(resultdata, weighmentModeNo = 0, Idsno) {
    try {
      var mstSerNo = "";
      var sideNo = "";
      let strIdsNo = Idsno;
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.Hmi == strIdsNo);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      var arrProductType = globalData.arrProductTypeArray.find(
        (k) => k.Hmi == selectedIdsNo
      );
      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let responseObj = {};
      const checkData = await models[resultdata.completeTableName].findAll({
        attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "SeqNo"]],
        attributes: [[sequelize.fn("max", sequelize.col("MstSerNo")), "MstSerNo"]],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          PVersion: resultdata.incompleteData.PVersion,
          Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno,
        },
      });
      // const checkData = {
      //     str_tableName: resultdata.completeTableName,
      //     data: 'MAX(MstSerNo) AS SeqNo',
      //     condition: [
      //         { str_colName: 'BFGCode', value: resultdata.incompleteData.BFGCode, comp: 'eq' },
      //         { str_colName: 'ProductName', value: resultdata.incompleteData.ProductName, comp: 'eq' },
      //         { str_colName: 'PVersion', value: resultdata.incompleteData.PVersion, comp: 'eq' },
      //         { str_colName: 'Version', value: resultdata.incompleteData.Version, comp: 'eq' },
      //         { str_colName: 'BatchNo', value: resultdata.incompleteData.BatchNo, comp: 'eq' },
      //         { str_colName: 'Idsno', value: resultdata.incompleteData.Idsno, comp: 'eq' },
      //     ]
      // }
      if (productDetail.ProductType == 3) {
        checkData.condition.push({
          str_colName: "TestType",
          value: objMenu.menu,
          comp: "eq",
        });
      }
      var resultCompleteData = [checkData];
      var intMstSerNo;
      var MstSerNo = resultdata.incompleteData.MstSerNo
      if (resultCompleteData[0][0].SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData[0][0].SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }

      var masterCompleteData = await models[resultdata.completeTableName].create({
        MstSerNo: MstSerNo,
        SideNo: 1,
        // InstruId: resultdata.incompleteData.InstruId,
        BFGCode: resultdata.incompleteData.BFGCode,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: resultdata.incompleteData.ProductType,
        Qty: resultdata.incompleteData.Qty,
        GrpQty: resultdata.incompleteData.GrpQty,
        GrpFreq: resultdata.incompleteData.GrpFreq,
        Idsno: resultdata.incompleteData.Idsno,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        BalanceId: resultdata.incompleteData.BalanceId,
        BalanceNo: resultdata.incompleteData.BalanceNo,
        VernierId: resultdata.incompleteData.VernierId,
        VernierNo: resultdata.incompleteData.VernierNo,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: resultdata.incompleteData.PrDate,
        PrTime: momentObj(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        Side: productDetail.ProductType == 2 ? "NA" : resultdata.incompleteData.Side,
        Unit: resultdata.incompleteData.Unit,
        DecimalPoint: resultdata.incompleteData.DecimalPoint,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,
        Nom: resultdata.incompleteData.Nom,
        T1NegTol: resultdata.incompleteData.T1NegTol,
        T1PosTol: resultdata.incompleteData.T1PosTol,
        T2NegTol: resultdata.incompleteData.T2NegTol,
        T2PosTol: resultdata.incompleteData.T2PosTol,
        T1NegTolActual: resultdata.incompleteData.T1NegTolActual,
        T1PosTolActual: resultdata.incompleteData.T1PosTolActual,
        T2NegTolActual: resultdata.incompleteData.T2NegTolActual,
        T2PosTolActual: resultdata.incompleteData.T2PosTolActual,
        LimitOn: resultdata.incompleteData.LimitOn,
        NomEmpty: resultdata.incompleteData.NomEmpty,
        T1NegEmpty: resultdata.incompleteData.T1NegEmpty,
        T1PosEmpty: resultdata.incompleteData.T1PosEmpty,
        T2NegEmpty: resultdata.incompleteData.T2NegEmpty,
        T2PosEmpty: resultdata.incompleteData.T2PosEmpty,
        NomNet: resultdata.incompleteData.NomNet,
        T1NegNet: resultdata.incompleteData.T1NegNet,
        T1PosNet: resultdata.incompleteData.T1PosNet,
        T2NegNet: resultdata.incompleteData.T2NegNet,
        T2PosNet: resultdata.incompleteData.T2PosNet,
        IPQCType: resultdata.incompleteData.IPQCType,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: resultdata.incompleteData.BatchSize,
        FriabilityID: resultdata.incompleteData.FriabilityID,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: resultdata.incompleteData.RepoLabel11,
        RepoLabel12: resultdata.incompleteData.RepoLabel12,
        RepoLabel13: resultdata.incompleteData.RepoLabel13,
        RepoLabel14: resultdata.incompleteData.RepoLabel14,
        PrintNo: resultdata.incompleteData.PrintNo,
        IsArchived: resultdata.incompleteData.IsArchived,
        GraphType: resultdata.incompleteData.GraphType,
        BatchComplete: resultdata.incompleteData.BatchComplete,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        Department: resultdata.incompleteData.Department,
        // CheckedByID: resultdata.incompleteData.CheckedByID,
        // CheckedByName: resultdata.incompleteData.CheckedByName,
        CheckedByDate: resultdata.incompleteData.CheckedByDate,
        BRepSerNo: resultdata.incompleteData.BRepSerNo,
        // T1NMTTab :resultdata.incompleteDataTab,
        Layer: resultdata.incompleteData.Layer,
        Nom_stdtarget: resultdata.incompleteData.Nom_stdtarget,
        Stage: resultdata.incompleteData.Stage,
        Lot: resultdata.incompleteData.Lot,
        Area: resultdata.incompleteData.Area,
        AppearanceDesc: resultdata.incompleteData.AppearanceDesc,
        MachineSpeed_Min: resultdata.incompleteData.MachineSpeed_Min,
        MachineSpeed_Max: resultdata.incompleteData.MachineSpeed_Max,
        GenericName: resultdata.incompleteData.GenericName,
        BMRNo: resultdata.incompleteData.BMRNo,
        AvgWeight: resultdata.incompleteData.AvgWeight,
        MinWeight: resultdata.incompleteData.MinWeight,
        MaxWeight: resultdata.incompleteData.MaxWeight,
        StdDev: resultdata.incompleteData.StdDev,
        MinPer: resultdata.incompleteData.MinPer,
        MaxPer: resultdata.incompleteData.MaxPer,
        Deviation: resultdata.incompleteData.Deviation,
        StdLimit1: resultdata.incompleteData.StdLimit1,
        StdLimit2: resultdata.incompleteData.StdLimit2,
        NoOfBelow1: resultdata.incompleteData.NoOfBelow1,
        NoOfAbove1: resultdata.incompleteData.NoOfAbove1,
        NoOfBelow2: resultdata.incompleteData.NoOfBelow2,
        NoOfAbove2: resultdata.incompleteData.NoOfAbove2,
        TotalWeight: resultdata.incompleteData.TotalWeight,
        Remark: resultdata.incompleteData.Remark
      });

      // if (productDetail.ProductType == 3) {
      //     masterCompleteData.data.push({ str_colName: 'TestType', value: objMenu.menu })
      // }
      // if (productDetail.ProductType == 4 && serverConfig.ProjectName == "SunHalolGuj1" && weighmentModeNo == "D") {
      //     masterCompleteData.data.push(
      //        T3NegNet: resultdata.incompleteData.T3NegNet ,
      //        T3PosNet: resultdata.incompleteData.T3PosNet ,
      //        GraphTypeNet: resultdata.incompleteData.GraphTypeNet ,
      //     )
      // }
      // else if (productDetail.ProductType == 2 && weighmentModeNo == "D") {
      //     masterCompleteData.data.push(
      //        limitOnEmpty: resultdata.incompleteData.limitOnEmpty ,
      //        NMTTabEmpty: resultdata.incompleteData.NMTTabEmpty ,
      //        limitOnNet: resultdata.incompleteData.limitOnNet ,
      //        NMTTabNet: resultdata.incompleteData.NMTTabNet ,
      //        GraphTypeEmpty: resultdata.incompleteData.GraphTypeEmpty ,
      //        GraphTypeNet: resultdata.incompleteData.GraphTypeNet
      //     )
      // }
      var resultCompleteData = [masterCompleteData];
      var lastInsertedID = resultCompleteData[0].dataValues.RepSerNo;
      // var incompleteTableName = resultdata.incompleteTableName

      var fetchMasterRecord = await models[
        resultdata.completeTableName
      ].findAll({
        where: {
          RepSerNo: lastInsertedID,
        },
      });
      // {
      //     str_tableName: masterCompleteData.str_tableName,
      //     data: 'MstSerNo',
      //     condition: [
      //         { str_colName: 'RepSerNo', value: lastInsertedID, comp: 'eq' }]
      // }

      var objfetchMasterRecord = fetchMasterRecord;

      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = {
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DecimalPoint: v.DecimalPoint,
          MstSerNo: objfetchMasterRecord[0].MstSerNo,
          UserId: objfetchMasterRecord[0].UserId,
          UserName: objfetchMasterRecord[0].UserName,
          PrDate: momentObj().format("YYYY-MM-DD"),
          PrTime: momentObj().format("HH:mm:ss"),
          PrEndDate: momentObj().format("YYYY-MM-DD"),
          PrEndTime: momentObj().format("HH:mm:ss"),
          Side: objfetchMasterRecord[0].Side,
        };
        //  {
        //     str_tableName: resultdata.detailTableName,
        //     data: [
        //         { str_colName: 'RepSerNo', value: lastInsertedID },
        //         { str_colName: 'RecSeqNo', value: i + 1 },
        //         { str_colName: 'DataValue', value: v.DataValue },
        //         { str_colName: 'DecimalPoint', value: v.DecimalPoint },
        //         { str_colName: 'MstSerNo', value: objfetchMasterRecord[0][0].MstSerNo }
        //     ]
        // }
        if (productDetail.ProductType == 3) {
          insertDetailObj.data.push({
            str_colName: "DataValue1",
            value: v.DataValue1,
          });
          insertDetailObj.data.push({
            str_colName: "NetWeight",
            value: v.NetWeight,
          });
          insertDetailObj.data.push({ str_colName: "Remark", value: v.Remark });
        } else if (
          (productDetail.ProductType == 2 || productDetail.ProductType == 4) &&
          weighmentModeNo == "D"
        ) {
          // insertDetailObj.data.push({ DataValue1: v.DataValue1 })
          Object.assign(insertDetailObj, { DataValue1: v.DataValue1 });
          // insertDetailObj.data.push({NetWeight: v.NetWeight })
          Object.assign(insertDetailObj, { NetWeight: v.NetWeight });
        }
        let res = await models[resultdata.detailTableName].create(
          insertDetailObj
        );
      }
      // var result1 = await models[resultdata.incompleteTableName].findAll({
      //   attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), "RepSerNo"]],
      // }, {
      //   where: {
      //     BalanceId: resultdata.incompleteData[0][0].BalanceId
      //   }
      // })
      const deleteIncompleteData = await models[
        resultdata.incompleteTableName
      ].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        },
      });
      // {
      //     str_tableName: resultdata.incompleteTableName,
      //     condition: [
      //         { str_colName: 'RepSerNo', value: resultdata.incompleteData.RepSerNo, comp: 'eq' },

      //     ]
      // }
      let res = [deleteIncompleteData];

      const deleteIncompleteDetailData = await models[
        resultdata.incompletedetailTableName
      ].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        },
      });
      // {
      //     str_tableName: resultdata.incompletedetailTableName,
      //     condition: [
      //         { str_colName: 'RepSerNo', value: resultdata.incompleteData.RepSerNo, comp: 'eq' },
      //     ]
      // }
      let res1 = deleteIncompleteDetailData;
      //Online Printing
      // const objIOnlinePrint = new IOnlinePrint();
      // objIOnlinePrint.RepSerNo = lastInsertedID;
      // switch (resultdata.incompleteData.WgmtModeNo) {
      //     case 1:
      //         objIOnlinePrint.reportOption = "Individual";
      //         //calculation = true;
      //         break;
      //     case 3:
      //         objIOnlinePrint.reportOption = "Thickness";
      //         //calculation = true;
      //         break;
      //     case 4:
      //         objIOnlinePrint.reportOption = "Breadth";
      //         //calculation = true;
      //         break;
      //     case 5:
      //         objIOnlinePrint.reportOption = "Length";
      //         //calculation = true;
      //         break;
      //     case 6:
      //         objIOnlinePrint.reportOption = "Diameter";
      //         // calculation = true;
      //         break;
      //     case 9:
      //         objIOnlinePrint.reportOption = "Individual Layer";
      //         //calculation = true;
      //         break;
      //     case 11:
      //         objIOnlinePrint.reportOption = "Individual Layer1";
      //         //calculation = true;
      //         break;
      //     default:
      //         break;
      // }
      //print online Report for Regular only
      // if (resultdata.incompleteData.ReportType == 0 && globalData.arrsAllParameters[0].tbl_PrintingMode == 'Auto') {
      //     objIOnlinePrint.testType = "Regular";
      //     objIOnlinePrint.userId = resultdata.incompleteData.UserId;
      //     objIOnlinePrint.username = resultdata.incompleteData.UserName;
      //     objIOnlinePrint.idsNo = Idsno
      //     const objPrinterName = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == Idsno);
      //     await objPrintReport.generateOnlineReport(objIOnlinePrint, objPrinterName.Sys_PrinterName);
      // }

      Object.assign(responseObj, { status: "success", RepSerNo: lastInsertedID });

      return responseObj;
    } catch (err) {
      console.log("Error message : " + err);
      // var logError = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " , " + err;
      // logError = logError + err;
      // //ErrorLog.error(logError);
      // ErrorLog.addToErrorLog(logError);
      //******************************************************************* */
      throw new Error(err);
    }
  }

  async saveCommonDataToCompleteHardness(
    resultdata,
    weighmentModeNo = 0,
    Idsno
  ) {
    try {
      var mstSerNo = "";
      var sideNo = "";

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == Idsno);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = Idsno;
      }

      var arrProductType = globalData.arrProductTypeArray.find(
        (k) => k.idsNo == selectedIdsNo
      );

      let cubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;

      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let responseObj = {};

      let tableName = resultdata.completeTableName;

      const checkData = await models[tableName].findAll({
        attributes: [[sequelize.fn("max", sequelize.col("MstSerNo")), "SeqNo"]],
        where: {
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          BatchNo: cubicalObj.Sys_Batch,
        },
      });

      var resultCompleteData = checkData

      var intMstSerNo;
      if (resultCompleteData[0].SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData[0].SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }

      const masterCompleteData = await models[resultdata.completeTableName].create({
        MinPerHard: resultdata.incompleteData.MinPerHard,
        MaxPerHard: resultdata.incompleteData.MaxPerHard,
        MinPerThick:resultdata.incompleteData.MinPerThick,
        MaxPerThick:resultdata.incompleteData.MaxPerThick,
        // MinPerDiam:resultdata.incompleteData.MinPerDiam,
        // MaxPerDiam:resultdata.incompleteData.MaxPerDiam,
        MinPerBL:resultdata.incompleteData.MinPerBL,
        MaxPerBL:resultdata.incompleteData.MaxPerBL,
        MstSerNo: intMstSerNo,
        InstruId: resultdata.incompleteData.HardnessID,
        BFGCode: resultdata.incompleteData.BFGCode,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: resultdata.incompleteData.ProductType,
        Qty: parseInt(resultdata.incompleteData.Qty),
        GrpQty: 0,
        GrpFreq: 0,
        Idsno: resultdata.incompleteData.Idsno,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        BalanceId: resultdata.incompleteData.BalanceId,
        BalanceNo: resultdata.incompleteData.BalanceNo,
        VernierId: resultdata.incompleteData.VernierId,
        VernierNo: resultdata.incompleteData.VernierNo,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: momentObj(resultdata.incompleteData.PrDate).format("YYYY-MM-DD"),
        PrTime: momentObj(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
        PrEndDate: momentObj(resultdata.incompleteData.PrEndDate).format("YYYY-MM-DD"),
        PrEndTime: momentObj(resultdata.incompleteData.PrEndTime).format("HH:mm:ss"),
        Side: resultdata.incompleteData.Side,
        Unit: resultdata.incompleteData.Unit,
        DecimalPoint: resultdata.incompleteData.DecimalPoint,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,

        T1NegTolActualHard: resultdata.incompleteData.T1NegTolActualHard,
        T1PosTolActualHard: resultdata.incompleteData.T1PosTolActualHard,
        T1NegTolActualThick: resultdata.incompleteData.T1NegTolActualThick,
        T1PosTolActualThick: resultdata.incompleteData.T1PosTolActualThick,
        // T1NegTolActualDiam: resultdata.incompleteData.T1NegTolActualDiam,
        // T1PosTolActualDiam: resultdata.incompleteData.T1PosTolActualDiam,
        T1NegTolActualBL: resultdata.incompleteData.T1NegTolActualBL,
        T1PosTolActualBL: resultdata.incompleteData.T1PosTolActualBL,
        T2NegTolActualHard: resultdata.incompleteData.T2NegTolActual,
        T2PosTolActualHard: resultdata.incompleteData.T2PosTolActual,
        T2NegTolActualThick: resultdata.incompleteData.T2NegTolActualThick,
        T2PosTolActualThick: resultdata.incompleteData.T2PosTolActualThick,
        // T2NegTolActualDiam: resultdata.incompleteData.T2NegTolActualDiam,
        // T2PosTolActualDiam: resultdata.incompleteData.T2PosTolActualDiam,
        T2NegTolActualBL: resultdata.incompleteData.T2NegTolActualBL,
        T2PosTolActualBL: resultdata.incompleteData.T2PosTolActualBL,
        T3NegTolActualHard: resultdata.incompleteData.T3NegTolActual,
        T3PosTolActualHard: resultdata.incompleteData.T3PosTolActual,
        T3NegTolActualThick: resultdata.incompleteData.T3NegTolActualThick,
        T3PosTolActualThick: resultdata.incompleteData.T3PosTolActualThick,
        // T3NegTolActualDiam: resultdata.incompleteData.T3NegTolActualDiam,
        // T3PosTolActualDiam: resultdata.incompleteData.T3PosTolActualDiam,
        T3NegTolActualBL: resultdata.incompleteData.T3NegTolActualBL,
        T3PosTolActualBL: resultdata.incompleteData.T3PosTolActualBL,
        Nom_stdtarget: resultdata.incompleteData.Nom_stdtarget,
        NomThick: resultdata.incompleteData.NomThick,
        // NomDiam: resultdata.incompleteData.NomDiam,
        NomBL: resultdata.incompleteData.NomBL,
        T1NegTolHard: resultdata.incompleteData.T1NegTolHard,
        T1PosTolHard: resultdata.incompleteData.T1PosTolHard,
        T2NegTolHard: resultdata.incompleteData.T1NegTolHard,
        T2PosTolHard: resultdata.incompleteData.T1PosTolHard,
        T1NegTolThick: resultdata.incompleteData.T1NegTolThick,
        T1PosTolThick: resultdata.incompleteData.T1PosTolThick,
        // T1NegTolDiam: resultdata.incompleteData.T1NegTolDiam,
        // T1PosTolDiam: resultdata.incompleteData.T1PosTolDiam,
        T1NegTolBL: resultdata.incompleteData.T1NegTolBL,
        T1PosTolBL: resultdata.incompleteData.T1PosTolBL,
        // T2NegTolHard: resultdata.incompleteData.T2NegTol,
        // T2PosTolHard: resultdata.incompleteData.T2PosTol,
        T2NegTolThick: resultdata.incompleteData.T2NegTolThick,
        T2PosTolThick: resultdata.incompleteData.T2PosTolThick,
        // T2NegTolDiam: resultdata.incompleteData.T2NegTolDiam,
        // T2PosTolDiam: resultdata.incompleteData.T2PosTolDiam,
        T2NegTolBL: resultdata.incompleteData.T2NegTolBL,
        T2PosTolBL: resultdata.incompleteData.T2PosTolBL,
        T3NegTolHard: resultdata.incompleteData.T3NegTol,
        T3PosTolHard: resultdata.incompleteData.T3PosTol,
        T3NegTolThick: resultdata.incompleteData.T3NegTolThick,
        T3PosTolThick: resultdata.incompleteData.T3PosTolThick,
        // T3NegTolDiam: resultdata.incompleteData.T3NegTolDiam,
        // T3PosTolDiam: resultdata.incompleteData.T3PosTolDiam,
        T3NegTolBL: resultdata.incompleteData.T3NegTolBL,
        T3PosTolBL: resultdata.incompleteData.T3PosTolBL,
        AvgHard: resultdata.incompleteData.AvgHard,
        AvgThick: resultdata.incompleteData.AvgThick,
        // AvgDiam: resultdata.incompleteData.AvgDiam,
        AvgBL: resultdata.incompleteData.AvgBL,
        MinWeightHard: resultdata.incompleteData.MinWeightHard,
        MaxWeightHard: resultdata.incompleteData.MaxWeightHard,
        MinWeightThick: resultdata.incompleteData.MinWeightThick,
        MaxWeightThick: resultdata.incompleteData.MaxWeightThick,
        // MinWeightDiam: resultdata.incompleteData.MinWeightDiam,
        // MaxWeightDiam: resultdata.incompleteData.MaxWeightDiam,
        MinWeightBL: resultdata.incompleteData.MinWeightBL,
        MaxWeightBL: resultdata.incompleteData.MaxWeightBL,
        StdLimit1: resultdata.incompleteData.T1NegTol,
        StdLimit2: resultdata.incompleteData.T1PosTol,
        StdDevHard: resultdata.incompleteData.StdDevHard,
        StdDevThick: resultdata.incompleteData.StdDevThick,
        // StdDevDiam: resultdata.incompleteData.StdDevDiam,
        StdDevBL: resultdata.incompleteData.StdDevBL,
        // NoOfAbove1: resultdata.incompleteData.NoOfAbove1,
        // NoOfAbove2: resultdata.incompleteData.NoOfAbove2,
        // NoOfBelow1: resultdata.incompleteData.NoOfBelow1,
        // NoOfBelow2: resultdata.incompleteData.NoOfBelow2,
        RemarkHard: resultdata.incompleteData.RemarkHard,
        // RemarkDiam: resultdata.incompleteData.RemarkDiam,
        RemarkThick: resultdata.incompleteData.RemarkThick,
        RemarkBL: resultdata.incompleteData.RemarkBL,
        BLName: resultdata.incompleteData.BLName,
        Department: resultdata.incompleteData.Department,
        IPQCType: resultdata.incompleteData.IPQCType,
        // NomDOLOBO: resultdata.incompleteData.NomDOLOBO,
        // PosTolDOLOBO: resultdata.incompleteData.PosTolDOLOBO,
        // NegTolDOLOBO: resultdata.incompleteData.NegTolDOLOBO,
        ColHeadDOLOBO: resultdata.incompleteData.ColHeadDOLOBO,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: resultdata.incompleteData.BatchSize,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: 0,
        RepoLabel12: "Null",
        RepoLabel13: "Null",
        IsArchived: 0,
        GraphType: 0,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        BRepSerNo: resultdata.incompleteData.BRepSerNo,
        Lot: resultdata.incompleteData.Lot,
        Layer: resultdata.incompleteData.Layer,
        Area: resultdata.incompleteData.Area,
        Stage: resultdata.incompleteData.Stage
      });

      var lastInsertedID = masterCompleteData._previousDataValues.RepSerNo;

      for (let [i, v] of resultdata.detailData.entries()) {
        let tableName = resultdata.detailTableName;
        const insertDetailObj = await models[tableName].create({
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValueThick: v.DataValueThick,
          DataValueDOLOBO: v.DataValueDOLOBO,
          DataValueHard: v.DataValueHard,
          // DataValueBL: v.DataValueBL != "NA" ? v.DataValueBL : v.DataValueDiam ,
          DataValueBL: v.DataValueBL,
          // DataValueDiam: v.DataValueDiam,
          // DecimalPointThick: v.DecimalPointThick,
          // DecimalPointDOLOBO: v.DecimalPointDOLOBO,
          // DP: v.DP,
          UserId: resultdata.incompleteData.UserId,
          UserName: resultdata.incompleteData.UserName,
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          Version: resultdata.incompleteData.Version,
          PVersion: resultdata.incompleteData.PVersion,
          Side: resultdata.incompleteData.Side,
          BatchNo: resultdata.incompleteData.BatchNo,
          InstrumentId: resultdata.incompleteData.HardnessID,

          //idsNo: v.idsNo,
          PrDate: momentObj().format("YYYY-MM-DD"),
          PrTime: momentObj().format("HH:mm:ss"),
        });

      }

      const deleteIncompleteData = await models[
        resultdata.incompleteTableName
      ].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        },
      });



      const deleteIncompleteDetailData = await models[
        resultdata.incompletedetailTableName
      ].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        },
      });

      Object.assign(responseObj, { status: "success", repSerNo: lastInsertedID , masterData: masterCompleteData});

      return responseObj;

    } catch (err) {

      console.log("Error message : " + err);
      // var logError = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " , " + err;
      // logError = logError + err;
      // //ErrorLog.error(logError);
      // ErrorLog.addToErrorLog(logError);
      //******************************************************************* */
      throw new Error(err);
    }
  }

  async saveHardnessData8M(resultdata, srno, idsNo, strHmi, tableName) {
    try {
      var mstSerNo = "";
      var sideNo = "";
      let responseObj = {};


      const getIncompleteMasterData = await models[
        "tbl_tab_master7_incomplete"
      ].findAll({
        where: {
          RepSerNo: srno,
          Idsno: strHmi, //strHmi
        },
      });

      var masterData = [getIncompleteMasterData];
      var completeMastData = masterData[0][0];


      //idsno to strHmi
      const checkMasterData = await models[tableName].findAll({
        attributes: [[sequelize.fn("max", sequelize.col("MstSerNo")), "SeqNo"]],
        where: {
          BFGCode: completeMastData.BFGCode,
          ProductName: completeMastData.ProductName,
          PVersion: completeMastData.PVersion,
          Version: completeMastData.Version,
          BatchNo: completeMastData.BatchNo,
          Idsno: strHmi, //strHmi
        },
      });
      var result = [checkMasterData];
      var intMstSerNo;

      if (result[0][0].SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = result[0][0].SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }
      var mstTblName = "tbl_tab_master7";
      if (completeMastData.ReportType == 1) {
        //for Initial
        mstSerNo = intMstSerNo;
        sideNo = 1;
      } else {
        //regular
        let objMt50Like8M = {
          tableName: mstTblName,
          ReportType: 0,
          Side: completeMastData.Side,
          BFGCode: completeMastData.BFGCode,
          ProductName: completeMastData.ProductName,
          PVersion: completeMastData.PVersion,
          Version: completeMastData.Version,
          BatchNo: completeMastData.BatchNo,
          IdsNo: completeMastData.Idsno,
        };
        if (completeMastData.Side == "NA") {
          mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
            objMt50Like8M
          );
          sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50Like8M);

          if (sideNo < 10) {
            sideNo = sideNo + 1;
          } else {
            sideNo = 1;
            mstSerNo = mstSerNo + 1;
          }
        } else {
          mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
            objMt50Like8M
          );
          sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50Like8M);

          if (sideNo < 5) {
            sideNo = sideNo + 1;
          } else {
            sideNo = 1;
            mstSerNo = mstSerNo + 1;
          }
        }
      }

      let now = new Date();

      const masterCompleteData = await models["tbl_tab_master7"].create({
        MstSerNo: mstSerNo,
        SideNo: sideNo,
        InstruId: completeMastData.InstruId,
        BFGCode: completeMastData.BFGCode,
        ProductName: completeMastData.ProductName,
        ProductType: completeMastData.ProductType,
        Qty: completeMastData.Qty,
        //{ str_colName: 'GrpQty: completeMastData.GrpQty,
        //GrpFreq: completeMastData.GrpFreq,
        Idsno: completeMastData.Idsno,
        CubicalNo: completeMastData.CubicalNo,
        BalanceId: completeMastData.BalanceId,
        //{ str_colName: 'BalanceNo: completeMastData.BalanceNo,
        VernierId: completeMastData.VernierId,
        //{ str_colName: 'VernierNo: completeMastData.VernierNo,
        BatchNo: completeMastData.BatchNo,
        UserId: completeMastData.UserId,
        UserName: completeMastData.UserName,
        PrDate: completeMastData.PrDate,
        PrTime: completeMastData.PrTime,
        PrEndDate: date.format(now, "YYYY-MM-DD"),
        PrEndTime: date.format(now, "HH:mm:ss"),
        Side: completeMastData.Side,
        Unit: completeMastData.Unit,
        //DecimalPoint: completeMastData.DecimalPoint,
        WgmtModeNo: completeMastData.WgmtModeNo,

        Nom: completeMastData.Nom,
        T1NegTol: completeMastData.T1NegTol,
        T1PosTol: completeMastData.T1PosTol,
        limitOn: completeMastData.limitOn,
        CubicleType: completeMastData.CubicleType,
        //{ str_colName: 'FriabilityID: completeMastData.FriabilityID,
        ReportType: completeMastData.ReportType,
        MachineCode: completeMastData.MachineCode,
        BatchSize: completeMastData.BatchSize,

        // PrintNo: completeMastData.PrintNo,
        HardnessID: completeMastData.HardnessID,
        //{ str_colName: 'GraphType: completeMastData.GraphType,
        //{ str_colName: 'BatchComplete: completeMastData.BatchComplete,
        CubicleName: completeMastData.CubicleName,
        CubicleLocation: completeMastData.CubicleLocation,
        // CheckedByID: completeMastData.CheckedByID,
        // CheckedByName: completeMastData.CheckedByName,
        // CheckedByDate: completeMastData.CheckedByDate,
        // BRepSerNo: completeMastData.BRepSerNo,
        RepoLabel10: completeMastData.RepoLabel10,
        RepoLabel11: completeMastData.RepoLabel11,

        RepoLabel12: completeMastData.RepoLabel12,
        RepoLabel13: completeMastData.RepoLabel13,
        RepoLabel14: completeMastData.RepoLabel14,
        IsArchived: completeMastData.IsArchived,

        GraphType: completeMastData.GraphType,
        PVersion: completeMastData.PVersion,
        Version: completeMastData.Version,

        //BRepSerNo: completeMastData.BRepSerNo,
        Lot: completeMastData.Lot,
        Area: completeMastData.Area,
        AppearanceDesc: completeMastData.AppearanceDesc,
        MachineSpeed_Min: completeMastData.MachineSpeed_Min,
        MachineSpeed_Max: completeMastData.MachineSpeed_Max,
        GenericName: completeMastData.GenericName,
        BMRNo: completeMastData.BMRNo,
        DecimalPoint: completeMastData.DecimalPoint,
      });

      //console.log(masterCompleteData);
      var masterSrno = [masterCompleteData];
      var lastInsertedId = masterCompleteData._previousDataValues.RepSerNo;

      // const getIncompleteDetailData = {
      //     str_tableName: 'tbl_tab_detail7_incomplete',
      //     data: '*',
      //     condition: [
      //         { str_colName: 'RepSerNo',value: srno, comp: 'eq' },
      //     ]
      // }
      // var detailData = await database.select(getIncompleteDetailData);

      const getIncompleteDetailData = await models[
        "tbl_tab_detail7_incomplete"
      ].findAll({
        where: {
          RepSerNo: srno,
        },
      });
      //var completedetailData = [getIncompleteDetailData][0][0];
      var completedetailData = [getIncompleteDetailData][0];
      //pending
      //var remarkRes = await objBatchSummary.saveBatchDataHardness8M(completeMastData, completedetailData, idsNo);

      for (const [i, v] of resultdata.detailData.entries()) {
        // const insertDetailObj = {
        //     str_tableName: 'tbl_tab_detail7',
        //     data: [
        //         { str_colName: 'RepSerNo', value: lastInsertedId },
        //         { str_colName: 'MstSerNo', value: 0 },
        //         { str_colName: 'RecSeqNo', value: i + 1 },
        //         { str_colName: 'DataValue', value: v.DataValue },
        //         { str_colName: 'DecimalPoint', value: v.DecimalPoint }
        //     ]
        // }
        // var res = await database.save(insertDetailObj);

        const insertDetailObj = await models["tbl_tab_detail7"].create({
          RepSerNo: lastInsertedId,
          MstSerNo: 0,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DecimalPoint: v.DecimalPoint,
        });
      }


      const deleteIncompleteMasterData = await models[
        "tbl_tab_master7_incomplete"
      ].destroy({
        where: {
          RepSerNo: srno,
          Idsno: strHmi,
        },
      });

      const deleteIncompleteDetailData = await models[
        "tbl_tab_detail7_incomplete"
      ].destroy({
        where: {
          RepSerNo: srno,
        },
      });

      Object.assign(responseObj, { status: "success" });

      // return remarkRes;
      return responseObj;
    } catch (err) {
      //******************************************************************* */
      console.log("error from Hardness Saving", err);
    }
  }

  async saveDataToCompletePerFineAndParticalSizing(resultdata, weighmentModeNo = 0, Idsno) {
    try {
      let now = new Date();
      var mstSerNo = "";
      var sideNo = "";
      var arrProductType = globalData.arrProductTypeArray.find((k) => k.idsNo == Idsno);
      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let responseObj = {};
      var str_tableName = resultdata.completeTableName;
      const checkData = await models[str_tableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          PVersion: resultdata.incompleteData.PVersion,
          Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno
        }
      })
      if (productDetail.ProductType == 3) {
        checkData.condition.push({
          str_colName: "TestType",
          value: objMenu.menu,
          comp: "eq",
        });
      }
      var resultCompleteData = checkData;
      var intMstSerNo;
      if (resultCompleteData[0].RepSerNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData[0].RepSerNo + 1;
        intMstSerNo = newMstSerNo;
      }

      var masterCompleteData = await models[str_tableName].create({
        MstSerNo: intMstSerNo,
        InstruId: 1,
        BFGCode: resultdata.incompleteData.BFGCode,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: resultdata.incompleteData.ProductType,
        Qty: resultdata.incompleteData.Qty,
        GrpQty: resultdata.incompleteData.GrpQty,
        GrpFreq: resultdata.incompleteData.GrpFreq,
        Idsno: resultdata.incompleteData.Idsno,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        BalanceId: resultdata.incompleteData.BalanceId,
        VernierId: resultdata.incompleteData.VernierId,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: resultdata.incompleteData.PrDate,
        PrTime: momentObj(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        Side: "NA",
        Department: resultdata.incompleteData.Department,
        Unit: resultdata.incompleteData.Unit,
        DecimalPoint: resultdata.incompleteData.DecimalPoint,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,
        Nom: 0,
        T1NegTol: resultdata.incompleteData.T1NegTol,
        T1PosTol: resultdata.incompleteData.T1PosTol,
        StdLimit1: resultdata.incompleteData.StdLimit1,
        StdLimit2: resultdata.incompleteData.StdLimit2,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: `${resultdata.incompleteData.BatchSize} ${resultdata.incompleteData.Unit}`,
        FriabilityID: resultdata.incompleteData.FriabilityID,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: resultdata.incompleteData.RepoLabel11,
        PrintNo: 0,
        IsArchived: 0,
        GraphType: 0,
        BatchComplete: 0,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        Lot: resultdata.incompleteData.Lot, //objLotData.LotNo
        AppearanceDesc: resultdata.incompleteData.AppearanceDesc,
        MachineSpeed_Min: resultdata.incompleteData.MachineSpeed_Min,
        MachineSpeed_Max: resultdata.incompleteData.MachineSpeed_Max,
        GenericName: resultdata.incompleteData.GenericName,
        BMRNo: resultdata.incompleteData.BMRNo,
        Layer: resultdata.incompleteData.Layer,
        LayerName: resultdata.incompleteData.LayerName,
        Stage: resultdata.incompleteData.Stage,
        Area: resultdata.incompleteData.Area,
        Remark: resultdata.incompleteData.Remark,
        Inprocess: 0,
        SieveID: resultdata.incompleteData.SieveID,
        IPQCType: resultdata.incompleteData.IPQCType,
      })
      var resultCompleteData = masterCompleteData;
      var lastInsertedID = resultCompleteData.dataValues.RepSerNo;

      var fetchMasterRecord = await models[str_tableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
      }, {
        where: {
          RepSerNo: lastInsertedID,
        }
      }
      )
      var objfetchMasterRecord = fetchMasterRecord;

      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = await models[resultdata.detailTableName].create({
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DecimalPoint: v.DP,
          MeshValue: v.MeshValue,
          SampleQuantity: v.SampleQuantity,
          T2NegTol: v.T2NegTol,
          T2PosTol: v.T2PosTol,
          FinePer: v.FinePer,
          QuantityRetained: v.QuantityRetained,
          MstSerNo: objfetchMasterRecord[0].RepSerNo,
          MeshPer: v.MeshPer,
        })

        var respose = insertDetailObj;
      }

      const deleteIncompleteData = await models[resultdata.incompleteTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo
        }
      });
      const deleteIncompleteDetailData = await models[resultdata.incompletedetailTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo
        }

      });
      const powerdelete = await models.tbl_powerbackup.destroy({
        where: {
          Sys_Batch: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno
        }
      })

      responseObj.remark = resultdata.incompleteData.Remark;
      responseObj.repserno = lastInsertedID;

      Object.assign(responseObj, { status: "success" });

      return responseObj;
    } catch (err) {
      console.log("Error message : " + err);
      throw new Error(err);
    }
  }

  async saveDiffDataToComplete(resultdata, weighmentModeNo = 0, Idsno) {
    try {
      var mstSerNo = '';
      var sideNo = '';
      let strIdsNo = Idsno;
      let selectedIdsNo;


      var arrProductType = globalData.arrProductTypeArray.find(k => k.Hmi == strIdsNo);
      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strIdsNo);
      let responseObj = {};
      const checkData = await models[resultdata.completeTableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'SeqNo']],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          PVersion: resultdata.incompleteData.PVersion,
          Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno,

        }
      })
      var checkData1 = await models[resultdata.incompleteTableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'SeqNo']],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          PVersion: resultdata.incompleteData.PVersion,
          Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno,

        }
      })
      checkData1 = checkData1[0].SeqNo


      if (productDetail.ProductType == 3) {
        checkData.condition.push({ str_colName: 'TestType', value: objMenu.menu, comp: 'eq' })
      }
      var resultCompleteData = [checkData];
      var intMstSerNo;
      if (resultCompleteData[0][0].SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData[0][0].SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }
      intMstSerNo = Math.max(checkData1, intMstSerNo)


      var masterCompleteData = await models[resultdata.completeTableName].create({
        MstSerNo: intMstSerNo,
        SideNo: 0,
        // InstruId: resultdata.incompleteData.InstruId,
        BFGCode: resultdata.incompleteData.BFGCode,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: 2,
        Qty: resultdata.incompleteData.Qty,
        GrpQty: resultdata.incompleteData.GrpQty,
        GrpFreq: resultdata.incompleteData.GrpFreq,
        Idsno: resultdata.incompleteData.Idsno,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        BalanceId: resultdata.incompleteData.BalanceId,
        // BalanceNo: resultdata.incompleteData.BalanceNo,
        VernierId: resultdata.incompleteData.VernierId,
        // /VernierNo: resultdata.incompleteData.VernierNo,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: resultdata.incompleteData.PrDate,
        PrTime: momentObj(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        Side: (productDetail.ProductType == 2) ? 'NA' : resultdata.incompleteData.Side,
        Unit: resultdata.incompleteData.Unit,
        DecimalPoint: resultdata.incompleteData.DecimalPoint,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,
        Nom: resultdata.incompleteData.Nom,
        T1NegTol: resultdata.incompleteData.T1NegTol,
        T1PosTol: resultdata.incompleteData.T1PosTol,
        T2NegTol: resultdata.incompleteData.T2NegTol,
        T2PosTol: resultdata.incompleteData.T2PosTol,
        limitOn: resultdata.incompleteData.LimitOn,
        NomEmpty: resultdata.incompleteData.NomEmpty,
        T1NegEmpty: resultdata.incompleteData.T1NegEmpty,
        T1PosEmpty: resultdata.incompleteData.T1PosEmpty,
        T2NegEmpty: resultdata.incompleteData.T2NegEmpty,
        T2PosEmpty: resultdata.incompleteData.T2PosEmpty,
        NomNet: resultdata.incompleteData.NomNet,
        // T1NMTTab: resultdata.incompleteData.T1NMTTab,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        // MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: resultdata.incompleteData.BatchSize,
        FriabilityID: resultdata.incompleteData.FriabilityID,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        // CubicleLocation: resultdata.incompleteData.CubicleLocation,
        // RepoLabel10: resultdata.incompleteData.RepoLabel10,
        // RepoLabel11: resultdata.incompleteData.RepoLabel11,
        // RepoLabel12: resultdata.incompleteData.RepoLabel12,
        // RepoLabel13: resultdata.incompleteData.RepoLabel13,
        // RepoLabel14: resultdata.incompleteData.RepoLabel14,
        PrintNo: resultdata.incompleteData.PrintNo,
        IsArchived: resultdata.incompleteData.IsArchived,
        GraphType: resultdata.incompleteData.GraphType,
        BatchComplete: 0,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        // GraphTypeEmpty: resultdata.incompleteData.GraphTypeEmpty,
        // limitOnEmpty: resultdata.incompleteData.limitOnEmpty[0],
        // NMTTabEmpty: resultdata.incompleteData.NMTTabEmpty,
        NomNet: resultdata.incompleteData.NomNet,
        T1NegNet: resultdata.incompleteData.T1NegNet,
        T1PosNet: resultdata.incompleteData.T1PosNet,
        T2NegNet: resultdata.incompleteData.T2NegNet,
        T2PosNet: resultdata.incompleteData.T2PosNet,
        T1NegNetActual: resultdata.incompleteData.T1NegNetActual,
        T1PosNetActual: resultdata.incompleteData.T1PosNetActual,
        T2NegNetActual: resultdata.incompleteData.T2NegNetActual,
        T2PosNetActual: resultdata.incompleteData.T2PosNetActual,
        BatchComplete: resultdata.incompleteData.BatchComplete,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        // CheckedByID: resultdata.incompleteData.CheckedByID,
        // CheckedByName: resultdata.incompleteData.CheckedByName,
        // CheckedByDate: resultdata.incompleteData.CheckedByDate,
        // BRepSerNo: resultdata.incompleteData.BRepSerNo,
        Lot: resultdata.incompleteData.Lot,
        Area: resultdata.incompleteData.Area,
        // AppearanceDesc: resultdata.incompleteData.AppearanceDesc,
        // MachineSpeed_Min: resultdata.incompleteData.MachineSpeed_Min,
        // MachineSpeed_Max: resultdata.incompleteData.MachineSpeed_Max,
        // GenericName: resultdata.incompleteData.GenericName,
        BMRNo: resultdata.incompleteData.BMRNo,
        MinPer: resultdata.incompleteData.MinPer,
        MaxPer: resultdata.incompleteData.MaxPer,
        AvgNet: resultdata.incompleteData.AvgNet,
        Inprocess: 0,
        StdDev: resultdata.incompleteData.StdDev,
        TotalWeight: resultdata.incompleteData.TotalWeight,
        MinWeightNet: resultdata.incompleteData.MinWeightNet,
        MaxWeightNet: resultdata.incompleteData.MaxWeightNet,
        NoOfAbove1: resultdata.incompleteData.NoOfAbove1,
        NoOfBelow1: resultdata.incompleteData.NoOfBelow1,
        NoOfBelow2: resultdata.incompleteData.NoOfBelow2,
        NoOfAbove2: resultdata.incompleteData.NoOfAbove2,
        Remark: resultdata.incompleteData.Remark,
        StdLimit1: resultdata.incompleteData.StdLimit1,
        StdLimit2: resultdata.incompleteData.StdLimit2,
        AvgWeight: resultdata.incompleteData.AvgWeight,
        Department: resultdata.incompleteData.Department
        // // GraphTypeNet: resultdata.incompleteData.GraphTypeNet,
        // // limitOnNet: resultdata.incompleteData.limitOnNet[0],
        // // NMTTabNet: resultdata.incompleteData.NMTTabNet

      })


      var resultCompleteData = [masterCompleteData]
      var lastInsertedID = resultCompleteData[0].RepSerNo;
      // var incompleteTableName = resultdata.incompleteTableName

      var fetchMasterRecord = await models[resultdata.completeTableName].findAll({
        where: {
          RepSerNo: lastInsertedID
        }
      })


      var objfetchMasterRecord = fetchMasterRecord
      var updated = await this.calculate_differ(resultdata, lastInsertedID)
      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = {
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DecimalPoint: v.DecimalPoint,
          MstSerNo: objfetchMasterRecord[0].MstSerNo,
          Side: objfetchMasterRecord[0].Side,
          UserId: objfetchMasterRecord[0].UserId,
          UserName: objfetchMasterRecord[0].UserName

        }

        if (productDetail.ProductType == 3) {
          insertDetailObj.data.push({ str_colName: 'DataValue1', value: v.DataValue1 })
          insertDetailObj.data.push({ str_colName: 'NetValue', value: v.NetValue })
          insertDetailObj.data.push({ str_colName: 'Remark', value: v.Remark })
        } else if ((productDetail.ProductType == 2 || productDetail.ProductType == 4) && weighmentModeNo == "D") {
          // insertDetailObj.data.push({ DataValue1: v.DataValue1 })
          Object.assign(insertDetailObj, { DataValue1: v.DataValue1 })
          // insertDetailObj.data.push({NetWeight: v.NetWeight })
          Object.assign(insertDetailObj, { NetValue: v.NetValue })
        }

        let res = await models[resultdata.detailTableName].create(insertDetailObj);
      }

      const deleteIncompleteData = await models[resultdata.incompleteTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        }
      })

      let res = [deleteIncompleteData];

      const deleteIncompleteDetailData = await models[resultdata.incompletedetailTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo

        }
      })

      let res1 = deleteIncompleteDetailData;

      Object.assign(responseObj, { status: 'success', RepSerNo: lastInsertedID })

      return responseObj
    } catch (err) {
      console.log("Error message : " + err);

      throw new Error(err);
    }
  }
  async calculate_differ(Data, serial) {
    try {
      // var data = detailData
      var detailData = Data.detailData
      // var Nominal = 
      var DataValue_arr;
      DataValue_arr.push(detailData);
      var arr = [];
      var arr_empty = [];
      var arr_net = [];
      var total_weight = 0
      var total_weight_empty = 0
      var total_weight_net = 0
      for (var i = 0; i < detailData.length; i++) {
        var a = detailData[i].DataValue;
        arr.push(Number(a));
        console.log(arr);
        total_weight = Number(total_weight) + Number(detailData[i].DataValue)
        // var Bal_DP = detailData[i].DP
        var max_value = maths.max(arr);
        max_value = max_value.toFixed(3);
        var min_value = maths.min(arr);
        min_value = min_value.toFixed(3);
        var std_value = maths.std(arr);
        std_value = std_value.toFixed(3);
        var total = arr.reduce((acc, total) => {
          return Number(total) + Number(acc);
        }, 0)
        var avg = total / arr.length
        avg = maths.abs(avg).toFixed(3);
        // var Per_Dev = ((Nominal - avg) / Nominal) * 100;
        // Per_Dev = Number(Per_Dev).toFixed(DP);
        var minPer_value = ((Nominal - min_value) / Nominal) * 100;
        minPer_value = maths.abs(minPer_value).toFixed(2)
        var maxPer_value = ((max_value - Nominal) / Nominal) * 100;
        maxPer_value = maths.abs(maxPer_value).toFixed(2)
      }
      for (var i = 0; i < detailData.length; i++) {
        var a = detailData[i].DataValue1;
        arr_empty.push(Number(a));
        console.log(arr_empty);
        total_weight_empty = Number(total_weight_empty) + Number(detailData[i].total_weight_empty)
        // var Bal_DP = total_weight_empty[i].DP
        var max_value_empty = maths.max(arr_empty);
        max_value_empty = max_value.toFixed(3);
        var min_value_empty = maths.min(arr_empty);
        min_value_empty = min_value.toFixed(3);
        var std_value_empty = maths.std(arr_empty);
        std_value_empty = std_value.toFixed(3);
        var total_empty = arr_empty.reduce((acc, total) => {
          return Number(total_empty) + Number(acc);
        }, 0)
        var avg_empty = total / arr_empty.length
        avg_empty = maths.abs(avg).toFixed(3);
        // var Per_Dev = ((Nominal - avg) / Nominal) * 100;
        // Per_Dev = Number(Per_Dev).toFixed(DP);
        var minPer_value_empty = ((Nominal - min_value_empty) / Nominal) * 100;
        minPer_value_empty = maths.abs(minPer_value_empty).toFixed(2)
        var maxPer_value_empty = ((max_value_empty - Nominal) / Nominal) * 100;
        maxPer_value_empty = maths.abs(maxPer_value_empty).toFixed(2)
      }
      for (var i = 0; i < detailData.length; i++) {
        var a = detailData[i].NetValue;
        arr_net.push(Number(a));
        console.log(arr_net);
        total_weight_net = Number(total_weight_net) + Number(detailData[i].NetValue)
        // var Bal_DP = total_weight_empty[i].DP
        var max_value_net = maths.max(arr_net);
        max_value_net = max_value.toFixed(3);
        var min_value_net = maths.min(arr_net);
        min_value_net = min_value.toFixed(3);
        var std_value_net = maths.std(arr_net);
        std_value_net = std_value.toFixed(3);
        var total_net = arr_net.reduce((acc, total) => {
          return Number(total_net) + Number(acc);
        }, 0)
        var avg_net = total_net / arr_net.length
        avg_net = maths.abs(avg_net).toFixed(3);
        // var Per_Dev = ((Nominal - avg) / Nominal) * 100;
        // Per_Dev = Number(Per_Dev).toFixed(DP);
        var minPer_value_net = ((Nominal - min_value_net) / Nominal) * 100;
        minPer_value_net = maths.abs(minPer_value_net).toFixed(2)
        var maxPer_value_net = ((max_value_net - Nominal) / Nominal) * 100;
        maxPer_value_net = maths.abs(maxPer_value_net).toFixed(2)
      }
      var T1Pos_Tol, T1Neg_Tol, T2Pos_Tol, T2Neg_Tol;
      T1Pos_Tol = get_Datavalue1[0].T1PosTol;
      T1Neg_Tol = get_Datavalue1[0].T1NegTol;
      T2Pos_Tol = get_Datavalue1[0].T2PosTol;
      T2Neg_Tol = get_Datavalue1[0].T2NegTol;

      var nob1 = 0;
      var noa1 = 0;
      var nob2 = 0;
      var noa2 = 0;
      for (var i = 0; i < get_Datavalue.length; i++) {
        if (Number(get_Datavalue[i].DataValue) < Number(T2Neg_Tol)) { //No of below limit 2
          nob2 = nob2 + 1;
        } else if (Number(get_Datavalue[i].DataValue) > Number(T2Pos_Tol)) { //No of Above limit 2
          noa2 = noa2 + 1;
        }
        if (T1Neg_Tol != 0 && T1Pos_Tol != 0) {
          if (Number(get_Datavalue[i].DataValue) < Number(T1Neg_Tol) && Number(get_Datavalue[i].DataValue) >= Number(T2Neg_Tol)) { //No of below limit 1
            nob1 = nob1 + 1;
          } else if (Number(get_Datavalue[i].DataValue) > Number(T1Pos_Tol) && Number(get_Datavalue[i].DataValue) <= Number(T2Pos_Tol)) { //No of Above limit 1
            noa1 = noa1 + 1;
          }
        }
      }
      // console.log();
      console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);

    } catch (error) {

    }
  }
}

module.exports = WeighmentDataTransfer;
