const request = require('request')
const serverConfig = require('../../../../IncrencyV4CP10GConfig.json');
const globalData = require('../../global/globalData');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;

class PrintOperations {

    async callViewTabReport(data, productType, strHmi) {
        try {
            let cls = this
            let check = data;
            var APIPath;
            var cubicalObj = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: strHmi
                }
            })
            // let cubicalDetails = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let cubicalDetails = cubicalObj[0];
            let printerName = cubicalDetails.Sys_PrinterName;

            let sysConfig = await models.tbl_setallparameter.findOne();
            let printerMode = sysConfig.tbl_PrintingMode

            if (printerMode.toLowerCase() != "auto") {
                console.log('printer set in manual mode')
                return
            }
            if (check.reportOption == 'DT LAYER 1') {
                check.reportOption = 'DT Layer 1'
            }
            if (check.reportOption == 'DT LAYER 2') {
                check.reportOption = 'DT Layer 2'
            } else if (check.reportOption == 'LOD LAYER 1') {
                check.reportOption = 'LOD Layer 1'
            } else if (check.reportOption == 'LOD LAYER 2') {
                check.reportOption = 'LOD Layer 2'
            } else if (check.reportOption == 'Hardness') {
                check.reportOption = 'Hardness'
            }
            // if (productType == 2) {
            //     APIPath = 'tabletCapsule//viewCapsuleReport';
            // } else if (productType == 3) {
            //     APIPath = 'multihalerReport/ViewMultihalerReport';
            // } else if (productType == 1) {
            //     APIPath = 'tabletCapsule/ViewTabReport';
            // }
            Object.assign(check, { str_hmi: strHmi, str_source: "Auto" }) //Hmi
            if (productType == 1) {
                APIPath = 'tabletCapsule/viewSeparateReport';
            } else if (productType == 'Bin') {
                APIPath = 'bin/storeBinLabelDataInTemp';
                printerName = check.printername;
                delete check.printername
            } else {
                APIPath = 'tabletCapsule/viewSeparateReport';
            }
            let PrintApi = `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/${APIPath}`;

            await request({
                url: PrintApi,
                method: 'POST',
                body: check,
                json: true
            }, function (err, response, body) {
                if (err) {
                    console.log('Error while Printing Report Online', err)

                    return false;
                } else {
                    if (body == null || body == undefined) {
                        console.log('Error while Printing Report Online Body Blank');

                        //************************************************************** */
                        return false;
                    } else {


                        cls.printReport(body, check, printerName, productType, strHmi).then(res => {
                            return true;
                        }).catch(err => {
                            return err;
                        });

                    }
                }
            });
            // console.log(a)



        } catch (error) {
            console.log(error)
            throw new Error(error)
        }
    }

    generateOnlineReportAsync(objReport, printerName) {
        return new Promise((resolve, reject) => {
            let cls = this;
            var objReport1 = {
                "recordFrom": objReport.recordFrom,
                "reportOption": objReport.reportOption,
                "reportType": objReport.reportType,
                "testType": objReport.testType,
                "RepSerNo": objReport.RepSerNo,
                "userId": objReport.userId,
                "username": objReport.username,
                "idsNo": objReport.idsNo
            }

            var options = {
                method: 'POST',
                uri: `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/tabletRoute/ViewTabReport`,
                body: objReport1,
                json: true // Automatically stringifies the body to JSON
            };
            // var parsedBody = await axios.post(options.uri, options.body, json);

            rp(options).then(function (parsedBody) {
                cls.printReport(parsedBody, objReport1, printerName).then(res => {
                    resolve(true);
                }).catch(err => {
                    resolve(err);
                });
            })

        }).catch(error => {
            console.log(error);
            resolve(false);
        })

    }

    async checkForAutoPrint(printObj, printName) {
        var printStatus = await models.tbl_setallparameter.findOne()
        if (printStatus.toLowerCase() === "auto") {
            this.generateOnlineReportAsync(printObj, printName)
        }
    }

    async printReport(Response, ObjReportView, printerName, productType = 1, strHmi) {
        try {
            var reportName = "";
            let cubicalDetails = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            switch (ObjReportView.reportOption) {
                case "Individual":
                case "Individual Layer 1":
                case "Individual Layer 2":
                    reportName = 'Repo_Tab_Individual';
                    //calculation = true;
                    break;
                case 'Individual Empty':
                    reportName = 'Repo_Tab_Individual';
                    //calculation = true;
                    break;
                case "Group-Individual":
                    reportName = 'Repo_Tab_GroupIndividual';
                    //calculation = true;
                    break;
                case 'Thickness':
                    reportName = 'Repo_Tab_Vernier';
                    //calculation = true;
                    break;
                case 'Length':
                    reportName = 'Repo_Tab_Vernier';
                    //calculation = true;
                    break;
                case 'Breadth':
                    reportName = 'Repo_Tab_Vernier';
                    //calculation = true;
                    break;
                case 'Diameter':
                    reportName = 'Repo_Tab_Vernier';
                    // calculation = true;
                    break;
                case "Friability":
                    reportName = 'Repo_Tab_Friability';
                    //calculation = false;
                    break;
                case 'LOD':
                case 'LOD Layer 1':
                case 'LOD Layer 2':
                    reportName = 'Repo_Tab_LOD';
                    //calculation = false;
                    break;
                case "Tablet Tester":
                    reportName = 'Repo_Tab_Hardness_ST50';
                    //calculation = true;
                    break;
                case 'Particle Size':
                    reportName = 'Repo_Tab_ParticleSize';
                    //calculation = true;
                    break;
                case 'Fine %':
                case '% Fine Layer 1':
                case '% Fine Layer 2':
                    reportName = 'Repo_Tab_Fine';
                    //calculation = true;
                    break;
                case 'Particle Size':
                case 'Particle Size Layer 1':
                case 'Particle Size Layer 2':
                    reportName = 'Repo_Tab_ParticleSize';
                    break;
                case 'Tapped Density':
                case 'Tapped Density Layer 1':
                case 'Tapped Density Layer 2':
                    reportName = 'Repo_Tab_TD';
                    //calculation = false;
                    break;
                case 'Hardness':
                    reportName = 'Repo_Tab_Vernier';
                    //calculation = true;
                    break;
                case 'DT':
                    reportName = 'Repo_Tab_DT';
                    //calculation = true;
                    break;
                case 'DT Layer 1':
                    reportName = 'Repo_Tab_DT';
                    //calculation = true;
                    break;
                case 'DT Layer 2':
                    reportName = 'Repo_Tab_DT';
                    //calculation = true;
                    break;
                case GLOBAL_NOMENCLATURE.GroupMenu:
                    reportName = 'Repo_Tab_Group';
                    //calculation = true;
                    break;
                case GLOBAL_NOMENCLATURE.GroupLayerMenu:
                    reportName = 'Repo_Tab_Group';
                    //calculation = true;
                    break;
                case GLOBAL_NOMENCLATURE.GroupLayer1Menu:
                    reportName = 'Repo_Tab_Group';
                    //calculation = true;
                    break;
                case "Differential":
                    reportName = 'Repo_Cap_Differential';
                    //calculation = true;
                    break;
                case "Empty Shell":
                    reportName = 'Repo_Cap_EmptyShell';
                    //calculation = true;
                    break;

                case 'Net Content':
                case 'Dry Cartridge':
                case 'Dry Powder':
                    reportName = 'Repo_Mul_UniformityofContent';
                    break;
                case 'IPC':
                    reportName = 'RepoBinLabel';
                    productType = 'Bin'
                    Response = {
                        str_cubicleType: cubicalDetails.Sys_CubType,
                        str_ICReport: "Current",
                        UserId: ObjReportView.UserId,
                        UserName: ObjReportView.UserName,
                        RecNo: ObjReportView.RecNo,
                        cubType: cubicalDetails.Sys_CubTypes,
                        HmiId: strHmi,
                        watermark: false
                    }
                    break;
                default:
                    reportName = 'RepoBinLabel';
                    productType = 'Bin';
                    Response = {
                        str_cubicleType: cubicalDetails.Sys_CubType,
                        str_ICReport: "Current",
                        UserId: ObjReportView.UserId,
                        UserName: ObjReportView.UserName,
                        RecNo: ObjReportView.RecNo,
                        cubType: cubicalDetails.Sys_CubTypes,
                        HmiId: strHmi,
                        watermark: false
                    }
                    break;
            }
            let reportObj = {}
            var reportData = Response;
            reportData.waterMark = false
            // delete reportData.resCalculation.waterMark;
            // Object.assign(reportData.resCalculation, { waterMark: false });
            Object.assign(reportObj, { data: reportData, "FileName": reportName })
            if (printerName != "NA" && printerName != "" && printerName != null && printerName != 'None') {
                request({
                    url: `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/report/GenerateReport`,
                    method: 'POST',
                    body: reportObj,
                    json: true
                }, function (err, response, body) {

                    if (err) {
                        console.log('Error while Printing Report Online', err)
                        //************************************************************** */
                    } else {
                        if (body == null || body == undefined) {
                            console.log('Error while Printing Report Online Body Blank');
                            //************************************************************** */
                        } else {
                            var filepath = response.body.filepath;

                            let printRep = {}
                            Object.assign(
                                printRep,
                                { filepath: filepath },
                                { strSelectedPrinter: printerName }
                            )
                            if (err) {
                                console.log('Error while Printing Report Online', err)
                                //************************************************************** */
                            } else {
                                //console.log(res.body);
                                // setTimeout(()=>{return true;},2000)
                                const objPrintData = {
                                    intMasterSerNo: 0,
                                    intReportSerNo: ObjReportView.RepSerNo,
                                    reportOption: ObjReportView.reportOption,
                                    reportType: 'Complete',
                                    recordFrom: 'Current',
                                    strReason: '',
                                    strUserId: Response.UserId,
                                    strUserName: Response.UserName,
                                    intPrintCount: 0,
                                    int_ReportFormat: 1,
                                    str_url: productType == 1 ? "Tablet" : "Capsule"
                                }
                                if (productType == 3) {
                                    Object.assign(objPrintData, { RepSrNo: ObjReportView.RepSerNo })
                                } else if (productType == 'Bin') {
                                    Object.assign(objPrintData, { intRecNo: ObjReportView.RecNo, rptLabelForActivity: `Label Generation-${ObjReportView.str_cubicleType} Report Printed`, str_ICReport: 'Current', str_batchNo: cubicalDetails.Sys_Batch, str_type: cubicalDetails.Sys_CubType, int_printNo: 0, str_prdID: cubicalDetails.Sys_BFGCode, str_prdName: cubicalDetails.Sys_ProductName, str_prdVersion: cubicalDetails.Sys_PVersion, str_version: cubicalDetails.Sys_Version, strUserId: ObjReportView.UserId, strUserName: ObjReportView.UserName }, delete objPrintData.intMasterSerNo, delete objPrintData.reportType, delete objPrintData.recordFrom, delete objPrintData.intPrintCount, delete objPrintData.str_url)
                                }
                                else {
                                    Object.assign(objPrintData, { intReportSerNo: ObjReportView.RepSerNo })
                                }
                                var API_PATH = 'tabletCapsule/printcountup';
                                if (productType == 1) {
                                    API_PATH = 'tabletCapsule/printcountup';
                                } else if (productType == 2) {
                                    API_PATH = 'tabletCapsule/printcountup';
                                } else if (productType == 3) {
                                    API_PATH = 'multihalerReport/increasePrintCountMultihaler';
                                } else if (productType == 'Bin') {
                                    API_PATH = 'report/increasePrintCountUpBinLabel'
                                }
                                printRep.reportObj = objPrintData;
                                printRep.apiEndPoint = API_PATH;
                                request.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/report/PrintReport`, { json: printRep }, (err, res, body) => {
                                    if (err) {
                                        console.log(err)
                                    } else {
                                        console.log(res.body, res.body);
                                    }
                                    // if (err) {
                                    //     console.log('Error while Printing Report Online', err)
                                    //     //************************************************************** */
                                    // } else {
                                    //     //console.log(res.body);
                                    //     // setTimeout(()=>{return true;},2000)
                                    //     const objPrintData = {
                                    //         intMasterSerNo: 0,
                                    //         intReportSerNo: ObjReportView.RepSerNo,
                                    //         reportOption: ObjReportView.reportOption,
                                    //         reportType: 'Complete',
                                    //         recordFrom: 'Current',
                                    //         strReason: '',
                                    //         strUserId: Response.UserId,
                                    //         strUserName: Response.UserName,
                                    //         intPrintCount: 1,
                                    //         str_url: productType == 1 ? "Tablet" : "Capsule"
                                    //     }
                                    //     if (productType == 3) {
                                    //         Object.assign(objPrintData, { RepSrNo: ObjReportView.RepSerNo })
                                    //     } else if (productType == 'Bin') {
                                    //         Object.assign(objPrintData, { intRecNo: ObjReportView.RecNo, rptLabelForActivity: `Label Generation-${ObjReportView.str_cubicleType} Report Printed`, str_ICReport: 'Current', str_batchNo: cubicalDetails.Sys_Batch, str_type: cubicalDetails.Sys_CubType, int_printNo: 0, str_prdID: cubicalDetails.Sys_BFGCode, str_prdName: cubicalDetails.Sys_ProductName, str_prdVersion: cubicalDetails.Sys_PVersion, str_version: cubicalDetails.Sys_Version, strUserId: ObjReportView.UserId, strUserName: ObjReportView.UserName }, delete objPrintData.intMasterSerNo, delete objPrintData.reportType, delete objPrintData.recordFrom, delete objPrintData.intPrintCount, delete objPrintData.str_url)
                                    //     }
                                    //     else {
                                    //         Object.assign(objPrintData, { intReportSerNo: ObjReportView.RepSerNo })
                                    //     }
                                    //     var API_PATH = 'tabletCapsule/printcountup';
                                    //     if (productType == 1) {
                                    //         API_PATH = 'tabletCapsule/printcountup';
                                    //     } else if (productType == 2) {
                                    //         API_PATH = 'tabletCapsule/printcountup';
                                    //     } else if (productType == 3) {
                                    //         API_PATH = 'multihalerReport/increasePrintCountMultihaler';
                                    //     } else if (productType == 'Bin') {
                                    //         API_PATH = 'report/increasePrintCountUpBinLabel'
                                    //     }

                                    // request.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/${API_PATH}`, { json: objPrintData }, (err, res1, body) => {
                                    //     if (err) {
                                    //         console.log(err)
                                    //     } else {
                                    //         console.log(res.body, res1.body);
                                    //     }
                                    // })
                                })
                                return true

                            }
                        }
                    }
                });
            } else {
                console.log("Printer Name empty")
                //************************************************************** */
                return false;
            }

        } catch (error) {
            console.log('Error while Printing Report Online', error)
            // let logQ = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + error;
            // //logFromPC.info(logQ);
            // logFromPC.addtoProtocolLog(logQ)
            //************************************************************** */
            return false;
        }
    }

}

module.exports = PrintOperations;