const clsIpc = require('../model/IPC/ipc.model');
const objIpc = new clsIpc();
const validation = ["", null, undefined]


exports.selectedBin = (req, res) => {

    const validate = !validation.includes(req.body.Hmi) && typeof req.body.Hmi === 'string' &&
                     !validation.includes(req.body.HdHmi) && typeof req.body.HdHmi === 'string' &&
                     !validation.includes(req.body.selectedBin) && typeof req.body.selectedBin === 'string'&&
                     !validation.includes(req.body.UserId) && typeof req.body.UserId === 'string' &&
                     !validation.includes(req.body.UserName) && typeof req.body.UserName === 'string'

    if (validate) {
        objIpc.selectedBin(req.body).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500
            res.send({ status: 'fail', message: 'Internal server error' })
        })
    } else {
        res.statusCode = 400
        res.send({ status: 'fail', message: "Invalid value received" })
    }
}

exports.pendingWeighment = (req, res) => {

    const validate = !validation.includes(req.body.Hmi) && typeof req.body.Hmi === 'string'

    if (validate) {
        objIpc.pendingWeighment(req.body).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500
            res.send({ status: 'fail', message: 'Internal server error' })
        })
    } else {
        res.statusCode = 400
        res.send({ status: 'fail', message: "Invalid value received" })
    }
}

exports.getBinList = (req, res) => {

    var menu = ['Tare Weight', 'Gross Weight']

    const validate = !validation.includes(req.body.Hmi) && typeof req.body.Hmi === 'string'
        && menu.includes(req.body.menu)

    if (validate) {
        objIpc.getBinList(req.body).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500
            res.send({ status: 'fail', message: 'Internal server error' })
        })
    } else {
        res.statusCode = 400
        res.send({ status: 'fail', message: "Invalid value received" })
    }
}





// exports.selectCubicalForCoridoor = (req,res)=>{
//     objIpc.selectCubicalForCoridoor(req.body).then((result) => {
//         res.statusCode = 200;
//         res.send(result);
//     }).catch((err) => {
//         throw new Error(err)
//     })
// }